use AdventureWorks;

--List tables/sprocs in DB
exec sp_tables;
exec sp_stored_procedures;

--List columns/indices in a table
exec sp_columns 'Address', 'Person';
exec sp_helpindex 'Person.Address';

--List columns, indices, constrainst, references for a table
exec sp_help 'Person.Address';
--or Alt+F1 in the SSMS editor

--List dependencies of some object
exec sp_depends 'Person.Address';

--Display T-SQL view/sproc definition
exec sp_helptext 'HumanResources.vJobCandidateEducation';

--Space of a table (or DB with no args)
exec sp_spaceused 'Person.Address';

--Which users/roles are in the DB?
exec sp_helpuser;

--Who is logged on?
exec sp_who;
exec sp_who2;

select session_id, login_time, login_name, last_request_start_time, last_request_end_time
from sys.dm_exec_sessions where session_id >= 51;

--Active connection info
select session_id, client_net_address, protocol_type, num_reads, num_writes
from sys.dm_exec_connections;

--What are the connections doing?
select session_id, command, database_id, user_id, blocking_session_id, percent_complete, sql_handle
from sys.dm_exec_requests where session_id >= 51;

--What SQL is a connection executing (needs session id)?
/*
Run this in another window:
select * from Person.Address p
where p.City like 'L%';
waitfor delay '00:01:00';
*/
select st.text from sys.dm_exec_requests r
cross apply
sys.dm_exec_sql_text(r.sql_handle) as st
where r.session_id = 52;
